
import gurobipy as gp

# Create a new model
model = gp.Model("Math Contest")

# Create variables
long_answer = model.addVar(vtype=gp.GRB.INTEGER, name="long_answer")
multiple_choice = model.addVar(vtype=gp.GRB.INTEGER, name="multiple_choice")

# Set objective function
model.setObjective(10 * long_answer + 2 * multiple_choice, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(long_answer + multiple_choice <= 15, "Total questions")
model.addConstr(long_answer >= 5, "Min long answer")
model.addConstr(multiple_choice >= 7, "Min multiple choice")
model.addConstr(long_answer <= 11, "Max long answer")
model.addConstr(multiple_choice <= 11, "Max multiple choice")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal score: {model.objVal}")
    print(f"Number of long answer questions: {long_answer.x}")
    print(f"Number of multiple choice questions: {multiple_choice.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

