
from gurobipy import *

# Create a new model
m = Model("Math_Contest")

# Define the variables
x1 = m.addVar(vtype=GRB.INTEGER, name="long_answer_questions")
x2 = m.addVar(vtype=GRB.INTEGER, name="multiple_choice_questions")

# Set the objective function
m.setObjective(10*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 15, "total_questions")
m.addConstr(x1 >= 5, "min_long_answer")
m.addConstr(x2 >= 7, "min_multiple_choice")
m.addConstr(x1 <= 11, "max_long_answer")
m.addConstr(x2 <= 11, "max_multiple_choice")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of long answer questions: {x1.x}")
    print(f"Number of multiple choice questions: {x2.x}")
    print(f"Maximum score: {m.objVal}")
else:
    print("No optimal solution found")
