
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, ub=11, vtype=gurobi.GRB.INTEGER, name="long_answer_questions")
    x2 = model.addVar(lb=0, ub=11, vtype=gurobi.GRB.INTEGER, name="multiple_choice_questions")

    # Set the objective function
    model.setObjective(10 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 15, name="total_questions")
    model.addConstr(x1 >= 5, name="min_long_answer")
    model.addConstr(x2 >= 7, name="min_multiple_choice")
    model.addConstr(x1 <= 11, name="max_long_answer")
    model.addConstr(x2 <= 11, name="max_multiple_choice")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum score: {10 * x1.varValue + 2 * x2.varValue}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
