
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("jewelry_production")

# Create variables
bracelets = m.addVar(vtype=GRB.INTEGER, name="bracelets")
rings = m.addVar(vtype=GRB.INTEGER, name="rings")

# Set objective function
m.setObjective(700 * bracelets + 300 * rings, GRB.MAXIMIZE)

# Add constraints
m.addConstr(bracelets <= 4, "bracelet_production_limit")
m.addConstr(rings <= 7, "ring_production_limit")
m.addConstr(bracelets + rings <= 30, "jeweler_capacity")
m.addConstr(bracelets >=0, "non_negative_bracelets")
m.addConstr(rings >= 0, "non_negative_rings")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of bracelets to produce: {bracelets.x}")
    print(f"Number of rings to produce: {rings.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

