
from gurobipy import *

# Create a new model
m = Model("Jewelry_Company_Profit")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="number_of_bracelets")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="number_of_rings")

# Set the objective function
m.setObjective(700*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 4, "bracelet_production_limit")
m.addConstr(x2 <= 7, "ring_production_limit")
m.addConstr(x1 + x2 <= 30, "jeweler_approval_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bracelets: {x1.x}")
    print(f"Number of rings: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
