
import gurobi

def solve_jewelry_company_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=4, name="bracelets")
    x2 = model.addVar(lb=0, ub=7, name="rings")

    # Objective function: Maximize 700*x1 + 300*x2
    model.setObjective(700*x1 + 300*x2, gurobi.GRB.MAXIMIZE)

    # Additional constraint: x1 + x2 <= 30
    model.addConstr(x1 + x2 <= 30, name="jeweler_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Bracelets: {x1.varValue}")
        print(f"Rings: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_jewelry_company_problem()
