
import gurobipy as gp

# Create a new model
m = gp.Model("Gardener_Optimization")

# Create variables
x1 = m.addVar(lb=0, name="sunflowers")  # Square feet of sunflowers
x2 = m.addVar(lb=0, name="roses")  # Square feet of roses


# Set objective function: Maximize profit
m.setObjective(450*x1 + 100*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, "field_size")  # Total area constraint
m.addConstr(67*x1 + 52*x2 <= 6500, "budget")  # Budget constraint


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Sunflowers: {x1.x} sq ft")
    print(f"Roses: {x2.x} sq ft")
    print(f"Maximum Profit: ${m.objVal}")

