
from gurobipy import *

# Create a new model
m = Model("Gardener_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sunflowers_area")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="roses_area")

# Set the objective function
m.setObjective(450*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, "total_area")
m.addConstr(67*x1 + 52*x2 <= 6500, "budget")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Area for sunflowers: {x1.x} square feet")
    print(f"Area for roses: {x2.x} square feet")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found.")
