
import gurobi

def solve_gardener_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="sunflowers_area", lb=0, ub=100)
    x2 = model.addVar(name="roses_area", lb=0, ub=100)

    # Objective function: Maximize 450*x1 + 100*x2
    model.setObjective(450 * x1 + 100 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100, name="total_area")
    model.addConstr(67 * x1 + 52 * x2 <= 6500, name="budget")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Sunflowers area: {x1.varValue}")
        print(f"Roses area: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_gardener_problem()
