
import gurobipy as gp

# Create a new model
m = gp.Model("smoothie_optimization")

# Create variables
fruit_smoothies = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fruit_smoothies")
vegetable_smoothies = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vegetable_smoothies")


# Set objective function
m.setObjective(4 * fruit_smoothies + 5 * vegetable_smoothies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * fruit_smoothies + 7 * vegetable_smoothies <= 400, "cutting_constraint")
m.addConstr(5 * fruit_smoothies + 4 * vegetable_smoothies <= 400, "blending_constraint")
m.addConstr(fruit_smoothies >=0)
m.addConstr(vegetable_smoothies >=0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Fruit smoothies: {fruit_smoothies.x}")
    print(f"Vegetable smoothies: {vegetable_smoothies.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

