
from gurobipy import *

# Create a new model
m = Model("Smoothie_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_smoothies")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vegetable_smoothies")

# Set the objective function
m.setObjective(4*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 7*x2 <= 400, "cutting_machine")
m.addConstr(5*x1 + 4*x2 <= 400, "blending_machine")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of fruit smoothies: {x1.x}")
    print(f"Number of vegetable smoothies: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
