
import gurobipy as gp

# Create a new model
m = gp.Model("CowFeed")

# Create variables
hay = m.addVar(nonneg=True, name="hay") # Kilograms of enriched hay
scraps = m.addVar(nonneg=True, name="scraps") # Kilograms of chicken scraps

# Set objective function
m.setObjective(200*hay + 350*scraps, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.3*hay + 0.6*scraps >= 1.5*30, "Protein")
m.addConstr(0.1*hay + 0.2*scraps <= 0.5*30, "Vitamin")
m.addConstr(0.15*hay + 0.05*scraps >= 0.5*30, "Mineral")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Kilograms of enriched hay: {hay.x:.2f}")
    print(f"Kilograms of chicken scraps: {scraps.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

