
from gurobipy import *

# Create a new model
m = Model("Cow_Feeding")

# Define the variables
x1 = m.addVar(lb=0, name="enriched_hay")
x2 = m.addVar(lb=0, name="chicken_scraps")

# Set the objective function
m.setObjective(6000*x1 + 10500*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.3*x1 + 0.6*x2 >= 1.5, "protein_requirement")
m.addConstr(0.15*x1 + 0.05*x2 >= 0.5, "mineral_requirement")
m.addConstr(0.1*x1 + 0.2*x2 <= 0.5, "vitamin_limitation")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Total cost: {m.ObjVal}")
else:
    print("No optimal solution found")
