
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="enriched_hay", lb=0)
    x2 = model.addVar(name="chicken_scraps", lb=0)

    # Objective function: minimize cost
    model.setObjective(200 * x1 + 350 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(0.3 * x1 + 0.6 * x2 >= 1.5, name="protein_requirement")
    model.addConstr(0.1 * x1 + 0.2 * x2 <= 0.5, name="vitamin_limit")
    model.addConstr(0.15 * x1 + 0.05 * x2 >= 0.5, name="mineral_requirement")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Enriched Hay: {x1.varValue} kg/cow/day")
        print(f"Chicken Scraps: {x2.varValue} kg/cow/day")
        print(f"Total Cost: ${model.objVal:.2f}/cow/day")
        print(f"For 30 cows, total cost: ${model.objVal * 30:.2f}/day")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
