
import gurobipy as gp

# Create a new model
m = gp.Model("sandwich_optimization")

# Create variables
premium = m.addVar(vtype=gp.GRB.INTEGER, name="premium")
regular = m.addVar(vtype=gp.GRB.INTEGER, name="regular")

# Set objective function
m.setObjective(5 * premium + 1 * regular, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * premium + 4 * regular <= 400, "prep_time")
m.addConstr(5 * premium + 1 * regular <= 100, "meat")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Premium Sandwiches: {premium.x}")
    print(f"  Regular Sandwiches: {regular.x}")
    print(f"  Total Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

