
from gurobipy import *

# Create a new model
m = Model("Sandwich_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="premium_sandwiches")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="regular_sandwiches")

# Set the objective function
m.setObjective(5*x1 + x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x1 + 4*x2 <= 400, "preparation_time")
m.addConstr(5*x1 + x2 <= 100, "meat_slices")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of premium sandwiches: {x1.x}")
    print(f"Number of regular sandwiches: {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
