
import gurobi

def solve_sandwich_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="premium_sandwiches", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="regular_sandwiches", lb=0, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(5 * x1 + x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6 * x1 + 4 * x2 <= 400, name="preparation_time")
    model.addConstr(5 * x1 + x2 <= 100, name="meat_slices")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of premium sandwiches: {x1.varValue}")
        print(f"Number of regular sandwiches: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_sandwich_problem()
