
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("FragranceMixture")

# Create variables
essential_oil = model.addVar(lb=0, name="essential_oil")
fruit_scent = model.addVar(lb=0, name="fruit_scent")

# Set objective function
model.setObjective(3.5 * essential_oil + 2 * fruit_scent, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * essential_oil + 10 * fruit_scent >= 6, "min_aromatic_notes")
model.addConstr(9 * essential_oil + 4 * fruit_scent >= 7, "min_duration")
model.addConstr(3 * essential_oil + 10 * fruit_scent <= 8, "max_aromatic_notes")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${model.objVal:.2f}")
    print(f"Essential Oil: {essential_oil.x:.2f} units")
    print(f"Fruit Scent: {fruit_scent.x:.2f} units")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

