
from gurobipy import *

# Create a new model
m = Model("Perfume_Mixture")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="essential_oil")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="fruit_scent")

# Set the objective function
m.setObjective(3.5*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 10*x2 >= 6, "aromatic_notes_min")
m.addConstr(9*x1 + 4*x2 >= 7, "duration_min")
m.addConstr(3*x1 + 10*x2 <= 8, "aromatic_notes_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Essential Oil: {x1.x}")
    print(f"Fruit Scent: {x2.x}")
    print(f"Total Cost: {m.objVal}")
else:
    print("No optimal solution found")
