
import gurobipy as gp

# Create a new model
model = gp.Model("Theta_Electronics")

# Create decision variables
regular_models = model.addVar(vtype=gp.GRB.CONTINUOUS, name="regular_models")
premium_models = model.addVar(vtype=gp.GRB.CONTINUOUS, name="premium_models")


# Set objective function
model.setObjective(200 * regular_models + 500 * premium_models, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(70 * regular_models + 100 * premium_models <= 6000, "assembly_time")
model.addConstr(25 * regular_models + 30 * premium_models <= 4000, "software_verification_time")
model.addConstr(regular_models >= 0, "regular_models_nonnegative")
model.addConstr(premium_models >= 0, "premium_models_nonnegative")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal}")
    print(f"Number of regular models: {regular_models.x}")
    print(f"Number of premium models: {premium_models.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

