
from gurobipy import *

# Create a new model
m = Model("Theta_Electronics")

# Define variables
x1 = m.addVar(name="regular_models", vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name="premium_models", vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(200*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(70*x1 + 100*x2 <= 6000, name="assembly_time")
m.addConstr(25*x1 + 30*x2 <= 4000, name="software_verification_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
