
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='regular_model', lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='premium_model', lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(200*x1 + 500*x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(70*x1 + 100*x2 <= 6000, name='assembly_time')
    model.addConstr(25*x1 + 30*x2 <= 4000, name='software_verification_time')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
