
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Berry Farm Optimization")

# Create variables
local_farm_days = m.addVar(lb=0, name="local_farm_days")
foreign_farm_days = m.addVar(lb=0, name="foreign_farm_days")

# Set objective function
m.setObjective(200 * local_farm_days + 500 * foreign_farm_days, GRB.MINIMIZE)

# Add constraints
m.addConstr(2.5 * local_farm_days + 5 * foreign_farm_days >= 12, "Raspberries")
m.addConstr(3 * local_farm_days + 4 * foreign_farm_days >= 10, "Bilberries")
m.addConstr(2 * local_farm_days + 4 * foreign_farm_days >= 20, "Strawberries")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal}")
    print(f"Local Farm Days: {local_farm_days.x}")
    print(f"Foreign Farm Days: {foreign_farm_days.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

