
from gurobipy import *

# Create a new model
m = Model("Berry_Farm")

# Define variables
x1 = m.addVar(name="local_farm_days", vtype=GRB.CONTINUOUS)
x2 = m.addVar(name="foreign_farm_days", vtype=GRB.CONTINUOUS)

# Set the objective function
m.setObjective(200*x1 + 500*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2.5*x1 + 5*x2 >= 12, name="raspberries_constraint")
m.addConstr(3*x1 + 4*x2 >= 10, name="bilberries_constraint")
m.addConstr(2*x1 + 4*x2 >= 20, name="strawberries_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Local farm operates for {x1.x} days")
    print(f"Foreign farm operates for {x2.x} days")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found.")

