
import gurobi

def solve_berry_farming_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="local_farm_days", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="foreign_farm_days", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(200 * x1 + 500 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2.5 * x1 + 5 * x2 >= 12, name="raspberries_contract")
    model.addConstr(3 * x1 + 4 * x2 >= 10, name="bilberries_contract")
    model.addConstr(2 * x1 + 4 * x2 >= 20, name="strawberries_contract")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Days to operate local farm: {x1.varValue}")
        print(f"Days to operate foreign farm: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_berry_farming_problem()
