
import gurobipy as gp

# Create a new model
m = gp.Model("tin_production")

# Create variables
tea = m.addVar(vtype=gp.GRB.CONTINUOUS, name="tea")  # Number of tea tins
coffee = m.addVar(vtype=gp.GRB.CONTINUOUS, name="coffee")  # Number of coffee tins


# Set objective function
m.setObjective(11 * tea + 13 * coffee, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * tea + 3 * coffee <= 500, "filling_time")
m.addConstr(1 * tea + 2 * coffee <= 600, "labeling_time")
m.addConstr(tea >= 0, "tea_nonnegative")  # Ensure non-negative number of tins
m.addConstr(coffee >= 0, "coffee_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of tea tins: {tea.x}")
    print(f"Number of coffee tins: {coffee.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

