
from gurobipy import *

# Create a new model
m = Model("Tea_Coffee_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="tea_tins", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="coffee_tins", lb=0)

# Set the objective function
m.setObjective(11*x1 + 13*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 3*x2 <= 500, "filling_time")
m.addConstr(x1 + 2*x2 <= 600, "labeling_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of tea tins: {x1.x}")
    print(f"Number of coffee tins: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
