
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="tea_tins")
    x2 = model.addVar(lb=0, name="coffee_tins")

    # Define the objective function
    model.setObjective(11*x1 + 13*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4*x1 + 3*x2 <= 500, name="filling_time_constraint")
    model.addConstr(x1 + 2*x2 <= 600, name="labeling_time_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of tea tins: {x1.varValue}")
        print(f"Number of coffee tins: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
