
import gurobipy as gp

# Create a new model
model = gp.Model("salad_optimization")

# Create variables
caesar = model.addVar(vtype=gp.GRB.CONTINUOUS, name="caesar")  # Number of Caesar salads
mediterranean = model.addVar(vtype=gp.GRB.CONTINUOUS, name="mediterranean")  # Number of Mediterranean salads

# Set objective function
model.setObjective(7 * caesar + 9 * mediterranean, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(100 * caesar + 150 * mediterranean <= 20000, "lettuce_constraint")
model.addConstr(10 * caesar + 15 * mediterranean <= 2000, "sauce_constraint")
model.addConstr(5 * caesar + 15 * mediterranean <= 3000, "cheese_constraint")
model.addConstr(caesar >= 0, "caesar_nonnegativity")  # Ensure non-negative number of salads.
model.addConstr(mediterranean >= 0, "mediterranean_nonnegativity")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Make {caesar.x:.2f} Caesar salads and {mediterranean.x:.2f} Mediterranean salads.")
    print(f"Maximum profit: ${model.objVal:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

