
from gurobipy import *

# Create a new model
m = Model("Salad_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Caesar_Salad", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Mediterranean_Salad", lb=0)

# Set the objective function
m.setObjective(7*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(100*x1 + 150*x2 <= 20000, "Lettuce_Constraint")
m.addConstr(10*x1 + 15*x2 <= 2000, "Sauce_Constraint")
m.addConstr(5*x1 + 15*x2 <= 3000, "Cheese_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Caesar Salads: {x1.x}")
    print(f"Mediterranean Salads: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found.")
