
import gurobi

def solve_salad_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="Caesar_salad", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="Mediterranean_salad", lb=0, ub=gurobi.GRB.INFINITY)

    # Set objective function
    model.setObjective(7*x1 + 9*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(100*x1 + 150*x2 <= 20000, name="Lettuce_constraint")
    model.addConstr(10*x1 + 15*x2 <= 2000, name="Sauce_constraint")
    model.addConstr(5*x1 + 15*x2 <= 3000, name="Cheese_constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Caesar salads: {x1.varValue}")
        print(f"Mediterranean salads: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_salad_problem()
