
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Museum_Ticket_Sales")

# Create variables
guided_tickets = m.addVar(lb=0, vtype=GRB.INTEGER, name="guided_tickets")
regular_tickets = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_tickets")


# Set objective function
m.setObjective(50 * guided_tickets + 20 * regular_tickets, GRB.MAXIMIZE)

# Add constraints
m.addConstr(guided_tickets + regular_tickets <= 300, "Total tickets")
m.addConstr(guided_tickets >= 50, "Minimum guided tickets")
m.addConstr(regular_tickets >= 3 * guided_tickets, "Regular vs guided")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of guided tickets: {guided_tickets.x}")
    print(f"Number of regular tickets: {regular_tickets.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

