
from gurobipy import *

# Create a model
m = Model("Museum_Ticket_Sales")

# Define variables
x1 = m.addVar(name="guided_tickets", lb=0)
x2 = m.addVar(name="regular_tickets", lb=0)

# Set the objective function
m.setObjective(50*x1 + 20*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 300, name="total_tickets")
m.addConstr(x1 >= 50, name="min_guided_tickets")
m.addConstr(x2 >= 3*x1, name="regular_vs_guided")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Guided tickets: {x1.x}")
    print(f"Regular tickets: {x2.x}")
    print(f"Total profit: ${50*x1.x + 20*x2.x:.2f}")
else:
    print("No optimal solution found")
