
import gurobi

def solve_museum_ticket_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='guided_tickets', lb=0, ub=300, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='regular_tickets', lb=0, ub=300, vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 50*x1 + 20*x2
    model.setObjective(50*x1 + 20*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 300, name='total_tickets')
    model.addConstr(x1 >= 50, name='min_guided_tickets')
    model.addConstr(x2 >= 3*x1, name='regular_to_guided_ratio')

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: guided tickets = {x1.varValue}, regular tickets = {x2.varValue}")
    else:
        print("The model is infeasible")

solve_museum_ticket_problem()
