
import gurobipy as gp

# Create a new model
model = gp.Model("PlantGrowthCompound")

# Create decision variables
p100 = model.addVar(lb=0, name="P100")  # kg of P100
y200 = model.addVar(lb=0, name="Y200")  # kg of Y200

# Set objective function: Minimize vitamin B
model.setObjective(4 * p100 + 6 * y200, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(11 * p100 + 9 * y200 >= 200, "Nitrogen")
model.addConstr(6 * p100 + 10 * y200 >= 150, "PhosphoricAcid")
model.addConstr(5 * p100 + 8 * y200 <= 300, "VitaminA")


# Optimize the model
model.optimize()

# Check if a solution was found
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  P100: {p100.x:.2f} kg")
    print(f"  Y200: {y200.x:.2f} kg")
    print(f"Minimum Vitamin B: {model.objVal:.2f} units")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

