
from gurobipy import *

# Create a new model
m = Model("Plant_Growth_Compound")

# Add variables
x1 = m.addVar(name="P100", lb=0)
x2 = m.addVar(name="Y200", lb=0)

# Set the objective function
m.setObjective(4*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x1 + 9*x2 >= 200, name="Nitrogen_Constraint")
m.addConstr(6*x1 + 10*x2 >= 150, name="Phosphoric_Acid_Constraint")
m.addConstr(5*x1 + 8*x2 <= 300, name="Vitamin_A_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"P100: {x1.x} kg")
    print(f"Y200: {x2.x} kg")
    print(f"Minimum Vitamin B: {4*x1.x + 6*x2.x} units")
else:
    print("No optimal solution found.")
