
import gurobipy as gp

# Create a new model
m = gp.Model("PlantGrowthCompound")

# Define the variables
x1 = m.addVar(name="P100", lb=0)  # kg of fertilizer P100
x2 = m.addVar(name="Y200", lb=0)  # kg of fertilizer Y200

# Define the objective function
m.setObjective(4*x1 + 6*x2, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(11*x1 + 9*x2 >= 200, name="Nitrogen_Requirement")
m.addConstr(6*x1 + 10*x2 >= 150, name="Phosphoric_Acid_Requirement")
m.addConstr(5*x1 + 8*x2 <= 300, name="Vitamin_A_Limit")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal amount of P100: {x1.varValue} kg")
    print(f"Optimal amount of Y200: {x2.varValue} kg")
    print(f"Minimum amount of vitamin B: {4*x1.varValue + 6*x2.varValue} units")
else:
    print("The model is infeasible.")
