
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Pie Production")

# Create variables
apple_pies = m.addVar(vtype=GRB.INTEGER, name="apple_pies")
blueberry_pies = m.addVar(vtype=GRB.INTEGER, name="blueberry_pies")

# Set objective function
m.setObjective(5 * apple_pies + 6 * blueberry_pies, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * apple_pies + 40 * blueberry_pies <= 4500, "Time Constraint")
m.addConstr(apple_pies <= 70, "Apple Pie Availability")
m.addConstr(blueberry_pies <= 60, "Blueberry Pie Availability")

# Solve the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of apple pies: {apple_pies.x}")
    print(f"Number of blueberry pies: {blueberry_pies.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

