
from gurobipy import *

# Create a new model
m = Model("Pie_Making_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="apple_pies")
x2 = m.addVar(vtype=GRB.INTEGER, name="blueberry_pies")

# Set the objective function
m.setObjective(5*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 40*x2 <= 4500, "time_constraint")
m.addConstr(x1 <= 70, "apple_pie_limit")
m.addConstr(x2 <= 60, "blueberry_pie_limit")
m.addConstr(x1 >= 0, "non_negative_apple")
m.addConstr(x2 >= 0, "non_negative_blueberry")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of apple pies: {x1.x}")
    print(f"Number of blueberry pies: {x2.x}")
    print(f"Maximum profit: ${5*x1.x + 6*x2.x}")
else:
    print("No optimal solution found")
