
import gurobi

def solve_pie_production():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="apple_pies")  # Number of apple pies
    x2 = model.addVar(lb=0, name="blueberry_pies")  # Number of blueberry pies

    # Objective function: Maximize profit
    model.setObjective(5 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(30 * x1 + 40 * x2 <= 4500, name="time_constraint")
    model.addConstr(x1 <= 70, name="apple_pies_limit")
    model.addConstr(x2 <= 60, name="blueberry_pies_limit")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Apple pies = {x1.varValue}, Blueberry pies = {x2.varValue}")
        print(f"Maximum profit: ${5 * x1.varValue + 6 * x2.varValue}")
    else:
        print("No optimal solution found.")

solve_pie_production()
