
import gurobipy as gp

# Create a new model
m = gp.Model("auto_plant")

# Create variables
cars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cars")
trucks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="trucks")

# Set objective function
m.setObjective(5000 * cars + 8000 * trucks, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * cars + 2.5 * trucks <= 800, "assembly_line")
m.addConstr(1 * cars + 1.5 * trucks <= 600, "mechanic_time")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Number of cars: {cars.x}")
    print(f"  Number of trucks: {trucks.x}")
    print(f"  Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

