
from gurobipy import *

# Create a new model
m = Model("Auto_Plant_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cars")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="trucks")

# Set the objective function
m.setObjective(5000*x1 + 8000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 2.5*x2 <= 800, "assembly_line_time")
m.addConstr(x1 + 1.5*x2 <= 600, "mechanic_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of cars: {x1.x}")
    print(f"Number of trucks: {x2.x}")
    print(f"Total profit: ${5000*x1.x + 8000*x2.x:.2f}")
else:
    print("No optimal solution found")
