
import gurobipy as gp

# Create a new model
model = gp.Model("AutoPlantProduction")

# Define variables
x1 = model.addVar(name="cars", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="trucks", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(5000*x1 + 8000*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2*x1 + 2.5*x2 <= 800, name="assembly_line_time")
model.addConstr(x1 + 1.5*x2 <= 600, name="mechanic_time")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of cars: {x1.varValue}")
    print(f"Optimal number of trucks: {x2.varValue}")
    print(f"Maximal profit: {model.objVal}")
else:
    print("The model is infeasible.")
