
import gurobipy as gp

# Create a new model
m = gp.Model("Restaurant_Optimization")

# Create variables
burritos = m.addVar(lb=0, name="burritos", type=gp.GRB.INTEGER)  # Integer variable for burritos
sandwiches = m.addVar(lb=0, name="sandwiches", type=gp.GRB.INTEGER) # Integer variable for sandwiches


# Set objective function
m.setObjective(2.5 * burritos + 7 * sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(25 * burritos + 15 * sandwiches <= 5000, "Pork_Constraint")
m.addConstr(sandwiches >= 4 * burritos, "Sales_Ratio_Constraint")
m.addConstr(burritos >= 6, "Min_Burritos_Constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of burritos: {burritos.x}")
    print(f"Number of sandwiches: {sandwiches.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

