
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Define variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="burritos", lb=0)
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="sandwiches", lb=0)

# Set the objective function
model.setObjective(2.5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(25*x1 + 15*x2 <= 5000, "pork_meat_limit")
model.addConstr(x2 >= 4*x1, "sandwich_burrito_ratio")
model.addConstr(x1 >= 6, "minimum_burritos")

# Optimize the model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Burritos: {x1.x}")
    print(f"Sandwiches: {x2.x}")
    print(f"Maximum Profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
