
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="burritos", lb=6, vtype=gurobi.GRB.INTEGER)  # At least 6 burritos
    x2 = model.addVar(name="sandwiches", vtype=gurobi.GRB.INTEGER)  # No lower bound specified, but implicitly non-negative

    # Objective function: Maximize 2.5x1 + 7x2
    model.setObjective(2.5 * x1 + 7 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(25 * x1 + 15 * x2 <= 5000, name="meat_constraint")
    model.addConstr(x2 >= 4 * x1, name="sandwich_burrito_ratio")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of burritos: {x1.varValue}")
        print(f"Optimal number of sandwiches: {x2.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
