
from gurobipy import *

# Create a new model
model = Model("Marys_Diet")

# Define the variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="protein_drink", lb=0)
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="fruit_snack", lb=0)

# Set the objective function
model.setObjective(4*x1 + 12*x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(45*x1 + 400*x2 >= 100, "Vitamin_A")
model.addConstr(200*x1 + 600*x2 >= 500, "Vitamin_C")
model.addConstr(300*x1 + 200*x2 >= 3000, "Proteins")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found")
