
import gurobi

def solve_diet_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="protein_drink", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="fruit_snack", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(4 * x1 + 12 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(45 * x1 + 400 * x2 >= 100, name="vitamin_A")
    model.addConstr(200 * x1 + 600 * x2 >= 500, name="vitamin_C")
    model.addConstr(300 * x1 + 200 * x2 >= 3000, name="proteins")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Protein drink servings: {x1.varValue}")
        print(f"Fruit snack servings: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_diet_problem()
