
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Gabriel's Farm")

# Create variables
pumpkins = m.addVar(name="pumpkins")
carrots = m.addVar(name="carrots")

# Set objective function
m.setObjective(2.5 * pumpkins + 3.4 * carrots, GRB.MAXIMIZE)

# Add constraints
m.addConstr(pumpkins + carrots <= 100, "Total Acres")
m.addConstr(pumpkins >= 7, "Minimum Pumpkins")
m.addConstr(carrots >= 12, "Minimum Carrots")
m.addConstr(carrots <= 3 * pumpkins, "Carrot to Pumpkin Ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Pumpkins: {pumpkins.x}")
    print(f"  Carrots: {carrots.x}")
    print(f"  Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

