
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=7, name="pumpkins")  # acres of pumpkins, minimum 7 acres
    x2 = model.addVar(lb=12, name="carrots")  # acres of carrots, minimum 12 acres

    # Objective function: maximize 2.5*x1 + 3.4*x2
    model.setObjective(2.5 * x1 + 3.4 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100, name="total_acres")  # Total acres available
    model.addConstr(x2 <= 3 * x1, name="carrots_vs_pumpkins")  # Carrots vs. pumpkins ratio

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of pumpkins: {x1.varValue}")
        print(f"Optimal acres of carrots: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
